/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.network.client.data;

import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOption;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.jetbrains.annotations.Nullable;

public class CommandDataSyncHandler
implements DataSyncHandler {
    @Nullable
    static ArmorStandScreenType lastType;
    private final ArmorStand armorStand;
    private ArmorStandPose lastSyncedPose;

    public CommandDataSyncHandler(ArmorStand armorStand) {
        this.armorStand = armorStand;
        this.lastSyncedPose = ArmorStandPose.fromEntity(armorStand);
    }

    @Override
    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    @Override
    public void sendName(String name) {
        if (!this.testPermissionLevel()) {
            return;
        }
        DataSyncHandler.super.sendName(name);
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)Component.m_237113_((String)name)));
        this.sendCommand(tag);
    }

    @Override
    public void sendPose(ArmorStandPose currentPose) {
        if (!this.testPermissionLevel()) {
            return;
        }
        DataSyncHandler.super.sendPose(currentPose);
        this.sendPosePart(currentPose::serializeBodyPoses, this.lastSyncedPose);
        this.sendPosePart(currentPose::serializeArmPoses, this.lastSyncedPose);
        this.sendPosePart(currentPose::serializeLegPoses, this.lastSyncedPose);
        this.lastSyncedPose = currentPose;
    }

    private void sendPosePart(BiPredicate<CompoundTag, ArmorStandPose> dataWriter, ArmorStandPose lastSyncedPose) {
        CompoundTag tag = new CompoundTag();
        if (dataWriter.test(tag, lastSyncedPose)) {
            CompoundTag tag1 = new CompoundTag();
            tag1.m_128365_("Pose", (Tag)tag);
            this.sendCommand(tag1);
        }
    }

    @Override
    public void sendPosition(double posX, double posY, double posZ) {
        if (!this.testPermissionLevel()) {
            return;
        }
        DataSyncHandler.super.sendPosition(posX, posY, posZ);
        ListTag listTag = new ListTag();
        listTag.add((Object)DoubleTag.m_128500_((double)posX));
        listTag.add((Object)DoubleTag.m_128500_((double)posY));
        listTag.add((Object)DoubleTag.m_128500_((double)posZ));
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Pos", (Tag)listTag);
        this.sendCommand(tag);
    }

    @Override
    public void sendRotation(float rotation) {
        if (!this.testPermissionLevel()) {
            return;
        }
        DataSyncHandler.super.sendRotation(rotation);
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.m_128566_((float)rotation));
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Rotation", (Tag)listTag);
        this.sendCommand(tag);
    }

    @Override
    public void sendStyleOption(ArmorStandStyleOption styleOption, boolean value) {
        if (!this.testPermissionLevel()) {
            return;
        }
        DataSyncHandler.super.sendStyleOption(styleOption, value);
        CompoundTag tag = new CompoundTag();
        styleOption.toTag(tag, value);
        this.sendCommand(tag);
    }

    @Override
    public ArmorStandScreenType[] tabs() {
        return (ArmorStandScreenType[])Stream.of(this.getDataProvider().getScreenTypes()).filter(Predicate.not(ArmorStandScreenType::requiresServer)).toArray(ArmorStandScreenType[]::new);
    }

    @Override
    public Optional<ArmorStandScreenType> getLastType() {
        List<ArmorStandScreenType> screenTypes = Arrays.asList(this.getDataProvider().getScreenTypes());
        return Optional.ofNullable(lastType).filter(screenTypes::contains).filter(Predicate.not(ArmorStandScreenType::requiresServer));
    }

    @Override
    public void setLastType(ArmorStandScreenType lastType) {
        CommandDataSyncHandler.lastType = lastType;
    }

    private boolean testPermissionLevel() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!player.m_20310_(2)) {
            player.m_5661_((Component)Component.m_237115_((String)"armorstatues.screen.noPermission").m_130940_(ChatFormatting.RED), false);
            return false;
        }
        return true;
    }

    private void sendCommand(CompoundTag tag) {
        Minecraft.m_91087_().f_91074_.m_234148_("data merge entity %s %s".formatted(this.getArmorStand().m_20149_(), tag.m_7916_()), null);
    }
}

